<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->integer('id', true)->primary();
			$table->string('product_name', 255);
			$table->text('product_des');
			$table->integer('qty');
			$table->decimal('MRP');
			$table->decimal('selling_price');
			$table->text('image');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
			$table->integer('fk_catid')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}