<?php

namespace Order;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Orders extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function orderType()
    {
        return $this->hasOne('OrderType');
    }

    public function getProduct()
    {
        return $this->hasOne('Products');
    }

    public function getUser()
    {
        return $this->hasOne('Users');
    }

}