<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOutlatesTable extends Migration {

	public function up()
	{
		Schema::create('outlates', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 225);
			$table->integer('banner')->unsigned();
			$table->text('address');
			$table->string('phone', 40);
			$table->string('hours', 40);
			$table->string('location', 225);
			$table->softDeletes();
			$table->timestamps();
			$table->boolean('status');
			$table->integer('zip_code');
		});
	}

	public function down()
	{
		Schema::drop('outlates');
	}
}