<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->json('name');
			$table->string('type');
			$table->boolean('is_active');
			$table->string('price')->nullable();
			$table->string('discount_type')->nullable();
			$table->string('discount_value')->nullable();
			$table->datetime('discount_start_date')->nullable();
			$table->datetime('discount_end_date')->nullable();
			$table->string('number_of_available_games')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}