<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAboutusTable extends Migration {

	public function up()
	{
		Schema::create('aboutus', function(Blueprint $table) {
			$table->increments('id');
			$table->string('short_desc', 255)->nullable();
			$table->text('video_img')->nullable();
			$table->string('video_url', 255)->nullable();
			$table->text('banner_image')->nullable();
			$table->string('banner_title', 255)->nullable();
			$table->string('overview_desc', 255)->nullable();
			$table->string('vision_desc', 255)->nullable();
			$table->string('mission_desc', 255)->nullable();
			$table->text('mission_img')->nullable();
			$table->text('accrediation_desc')->nullable();
			$table->string('chairman_msg', 255)->nullable();
			$table->text('chairman_img')->nullable();
			$table->string('chairman_name', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('aboutus');
	}
}