<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminTable extends Migration {

	public function up()
	{
		Schema::create('admin', function(Blueprint $table) {
			$table->increments('id');
			$table->string('role_id', 255)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('password', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->string('is_active', 255)->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('admin');
	}
}