<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('buyer_id')->unsigned();
			$table->bigInteger('seller_id')->unsigned();
			$table->float('discount')->nullable();
			$table->float('fee');
			$table->float('total')->nullable();
			$table->float('sub_total')->nullable();
			$table->tinyInteger('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}