<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('Products', function(Blueprint $table) {
			$table->increments('id');
			$table->float('rating_cache');
			$table->integer('rating_count');
			$table->integer('category_id');
			$table->string('name');
			$table->string('slug');
			$table->integer('stock');
			$table->float('pricing');
			$table->string('short_description');
			$table->text('long_description');
			$table->string('icon');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Products');
	}
}