<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenuItemsTable extends Migration {

	public function up()
	{
		Schema::create('menu_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('restaurant_id')->unsigned();
			$table->string('name', 45);
			$table->text('img');
			$table->text('desc');
			$table->decimal('price');
			$table->text('linked_ids')->nullable();
			$table->tinyInteger('deleted')->unsigned()->nullable();
			$table->integer('updated_to')->unsigned()->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('menu_items');
	}
}