<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrafficSourceTrackingsTable extends Migration {

	public function up()
	{
		Schema::create('traffic_source_trackings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('campaign_id')->unsigned();
			$table->integer('offer_id')->unsigned();
			$table->integer('traffic_source_id')->unsigned();
			$table->string('tracking_code');
			$table->string('country');
			$table->string('category');
			$table->boolean('converted')->default(false);
			$table->text('additional_params');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('traffic_source_trackings');
	}
}