<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeachersTable extends Migration {

	public function up()
	{
		Schema::create('teachers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email')->unique()->nullable();
			$table->string('password');
			$table->string('phone', 255);
			$table->string('address', 255)->nullable();
			$table->string('profile_image', 255)->nullable();
			$table->string('longitude', 255)->nullable();
			$table->string('latitude', 255)->nullable();
			$table->integer('experince')->nullable();
			$table->string('qualification', 255);
			$table->string('cv', 255)->nullable();
			$table->integer('lesson_type')->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('teachers');
	}
}