<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePublicationsTable extends Migration {

	public function up()
	{
		Schema::create('publications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('publication_type_id')->unsigned();
			$table->integer('profile_experience_id')->unsigned();
			$table->string('title');
			$table->string('description')->nullable();
			$table->integer('creator')->unsigned()->index();
			$table->integer('created_at')->unsigned();
			$table->integer('updated_at')->unsigned();
			$table->integer('deleted_at')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('publications');
	}
}