<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractorsTable extends Migration {

	public function up()
	{
		Schema::create('contractors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('national_id');
			$table->datetime('birth_date');
			$table->integer('social_status');
			$table->integer('family_count');
			$table->string('phone_num');
			$table->string('email')->nullable();
			$table->string('work_location');
			$table->integer('nationality_id');
			$table->integer('country_id');
			$table->integer('user_id');
			$table->integer('family_number')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contractors');
	}
}