<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('discounts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('code');
			$table->double('value');
			$table->enum('type', array('percent', 'amount'));
			$table->integer('period')->default('0');
			$table->integer('repeat')->default('0');
			$table->integer('max_uses')->default('0');
			$table->integer('uses')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('discounts');
	}
}