<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpensesTable extends Migration {

	public function up()
	{
		Schema::create('expenses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('realty_id');
			$table->integer('unit_id')->nullable();
			$table->integer('provider_id')->nullable();
			$table->datetime('date');
			$table->string('bill_num')->nullable();
			$table->double('total');
			$table->integer('exchange_id');
			$table->text('description');
			$table->integer('serial');
			$table->integer('user_id');
		});
	}

	public function down()
	{
		Schema::drop('expenses');
	}
}