<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitsTable extends Migration {

	public function up()
	{
		Schema::create('units', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('realty_id');
			$table->integer('unit_type')->nullable();
			$table->integer('unit_num')->nullable();
			$table->double('unit_space')->nullable();
			$table->string('floor')->nullable();
			$table->integer('floor_num')->nullable();
			$table->integer('rooms_num')->nullable();
			$table->integer('receptions_num')->nullable();
			$table->integer('bathrooms_num')->nullable();
			$table->enum('kitchen_cabinet', array('yes', 'no', ''))->nullable();
			$table->integer('shop_num')->nullable();
			$table->double('shop_space')->nullable();
			$table->integer('office_num')->nullable();
			$table->double('office_space')->nullable();
			$table->integer('desk_count')->nullable();
			$table->enum('private_parking', array('yes', 'no', ''))->nullable();
			$table->string('electricity_account')->nullable();
			$table->enum('one_water_account', array('yes', 'no', ''))->nullable();
			$table->double('rent_value')->nullable();
			$table->integer('rent_durations');
			$table->integer('unit_status')->nullable();
			$table->text('description')->nullable();
			$table->text('notes')->nullable();
			$table->integer('user_id');
			$table->string('water_account')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('units');
	}
}