<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoices extends Eloquent {

	protected $table = 'invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'order_id', 'total', 'paid');

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

	public function order()
	{
		return $this->belongsTo('Orders', 'order_id');
	}

}