<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PackageDiscount extends Eloquent {

	protected $table = 'package_discount';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('discount_id', 'package_id');

	public function discount()
	{
		return $this->belongsTo('Discounts', 'discount_id');
	}

	public function packages()
	{
		return $this->belongsTo('Packages', 'package_id');
	}

}