<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payments extends Eloquent {

	protected $table = 'payments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('date', 'paid', 'payment_method_id', 'bill_id', 'due');

	public function bill()
	{
		return $this->belongsTo('Bills', 'bill_id');
	}

	public function paymentmethod()
	{
		return $this->belongsTo('Paymentmethods', 'payment_method_id');
	}

}