<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Units extends Eloquent {

	protected $table = 'units';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('realty_id', 'unit_type', 'unit_num', 'unit_space', 'floor', 'floor_num', 'rooms_num', 'receptions_num', 'bathrooms_num', 'kitchen_cabinet', 'shop_num', 'shop_space', 'office_num', 'office_space', 'desk_count', 'private_parking', 'electricity_account', 'one_water_account', 'rent_value', 'rent_durations', 'unit_status', 'description', 'notes', 'user_id', 'water_account');

	public function realty()
	{
		return $this->belongsTo('Realties', 'realty_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

	public function expenses()
	{
		return $this->hasMany('Expenses', 'unit_id');
	}

	public function requests()
	{
		return $this->hasMany('Requests', 'unit_id');
	}

	public function bills()
	{
		return $this->hasMany('Bills', 'unit_id');
	}

	public function payments()
	{
		return $this->hasMany('Payments', 'unit_id');
	}

	public function contracts()
	{
		return $this->hasMany('Contracts', 'unit_id');
	}

	public function unittype()
	{
		return $this->belongsTo('Presets', 'unit_type');
	}

	public function rentdurations()
	{
		return $this->belongsTo('Presets', 'rent_durations');
	}

	public function unitstatus()
	{
		return $this->belongsTo('Presets', 'unit_status');
	}

}