<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PackageDiscount extends Model 
{

    protected $table = 'package_discount';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('discount_id', 'package_id');

    public function discount()
    {
        return $this->belongsTo('Discounts', 'discount_id');
    }

    public function packages()
    {
        return $this->belongsTo('Packages', 'package_id');
    }

}