<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Realties extends Model 
{

    protected $table = 'realties';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('realty_type', 'name', 'realty_num', 'space', 'floor_count', 'one_block', 'unit_count', 'electricity_account', 'water_account', 'one_water_account', 'land_license', 'land_space', 'land_value', 'city', 'district', 'street', 'building_number', 'postcode', 'additional_number', 'longitude', 'latitude', 'in_charge', 'responsible_name', 'responsible_phone', 'guard_is_responsible', 'guard_in_charge', 'guard_name', 'guard_phone', 'has_parking', 'parking_num', 'is_elevator_here', 'elevator_count', 'user_id', 'has_watchman');

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

    public function units()
    {
        return $this->hasMany('Units', 'realty_id');
    }

    public function expenses()
    {
        return $this->hasMany('Expenses', 'realty_id');
    }

    public function bills()
    {
        return $this->hasMany('Bills', 'realty_id');
    }

    public function requests()
    {
        return $this->hasMany('Requests', 'realty_id');
    }

    public function payments()
    {
        return $this->hasMany('Payments', 'realty_id');
    }

    public function contractors()
    {
        return $this->hasMany('Contractors', 'realty_id');
    }

    public function contracts()
    {
        return $this->hasMany('Contracts', 'realty_id');
    }

    public function realtytype()
    {
        return $this->belongsTo('Presets', 'realty_type');
    }

    public function licences()
    {
        return $this->hasMany('Presets', 'realty_id');
    }

    public function landlicense()
    {
        return $this->belongsTo('Presets', 'land_license');
    }

}