<?php

namespace Models;

class Trip extends Eloquent {

	protected $table = 'trips';
	public $timestamps = true;
	protected $fillable = array('user_id', 'driver_id', 'start_lat', 'start_lng', 'driver_lat', 'driver_lng', 'online', 'end_lat', 'end_lng', 'time_type', 'time', 'car_type_id', 'payment_id', 'trip_price', 'wallet_first', 'coupon_id', 'status', 'cancel_reason_id', 'start_time', 'end_time');

	public function user()
	{
		return $this->belongsTo('Models\User', 'user_id');
	}

	public function driver()
	{
		return $this->belongsTo('Models\User', 'driver_id');
	}

	public function car_type()
	{
		return $this->belongsTo('Models\CarTyps', 'car_type_id');
	}

	public function payment_id()
	{
		return $this->belongsTo('Models\PaymentType', 'payment_id');
	}

	public function cancelReason()
	{
		return $this->belongsTo('Models\Reason', 'cance_reason_id');
	}

	public function coupon()
	{
		return $this->belongsTo('Models\Coupon', 'coupon_id');
	}

}