<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConditionsTable extends Migration {

	public function up()
	{
		Schema::create('conditions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('workflow_id')->unsigned();
			$table->string('condition_name');
			$table->enum('operator', array('equal', 'not_equal'));
			$table->text('condition_settings');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('conditions');
	}
}