<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('workflows', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workflows', function(Blueprint $table) {
			$table->foreign('approved_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('steps', function(Blueprint $table) {
			$table->foreign('workflow_id')->references('id')->on('workflows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('steps', function(Blueprint $table) {
			$table->foreign('condition_id')->references('id')->on('conditions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('steps', function(Blueprint $table) {
			$table->foreign('assigned_to')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('conditions', function(Blueprint $table) {
			$table->foreign('workflow_id')->references('id')->on('workflows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('step_id')->references('id')->on('steps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('workflow_id')->references('id')->on('workflows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('integration_step', function(Blueprint $table) {
			$table->foreign('step_id')->references('id')->on('steps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('integration_step', function(Blueprint $table) {
			$table->foreign('integration_id')->references('id')->on('integrations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_workflow', function(Blueprint $table) {
			$table->foreign('workflow_id')->references('id')->on('workflows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_workflow', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('triggers', function(Blueprint $table) {
			$table->foreign('workflow_id')->references('id')->on('workflows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->foreign('field_id')->references('id')->on('fields')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('forms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->foreign('workflow_id')->references('id')->on('workflows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fields', function(Blueprint $table) {
			$table->foreign('step_id')->references('id')->on('steps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('connections', function(Blueprint $table) {
			$table->foreign('from_step_id')->references('id')->on('steps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('connections', function(Blueprint $table) {
			$table->foreign('to_step_id')->references('id')->on('steps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('connections', function(Blueprint $table) {
			$table->foreign('condition_id')->references('id')->on('conditions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('workflows', function(Blueprint $table) {
			$table->dropForeign('workflows_user_id_foreign');
		});
		Schema::table('workflows', function(Blueprint $table) {
			$table->dropForeign('workflows_approved_by_foreign');
		});
		Schema::table('steps', function(Blueprint $table) {
			$table->dropForeign('steps_workflow_id_foreign');
		});
		Schema::table('steps', function(Blueprint $table) {
			$table->dropForeign('steps_condition_id_foreign');
		});
		Schema::table('steps', function(Blueprint $table) {
			$table->dropForeign('steps_assigned_to_foreign');
		});
		Schema::table('conditions', function(Blueprint $table) {
			$table->dropForeign('conditions_workflow_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_step_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_workflow_id_foreign');
		});
		Schema::table('integration_step', function(Blueprint $table) {
			$table->dropForeign('integration_step_step_id_foreign');
		});
		Schema::table('integration_step', function(Blueprint $table) {
			$table->dropForeign('integration_step_integration_id_foreign');
		});
		Schema::table('user_workflow', function(Blueprint $table) {
			$table->dropForeign('user_workflow_workflow_id_foreign');
		});
		Schema::table('user_workflow', function(Blueprint $table) {
			$table->dropForeign('user_workflow_user_id_foreign');
		});
		Schema::table('triggers', function(Blueprint $table) {
			$table->dropForeign('triggers_workflow_id_foreign');
		});
		Schema::table('forms', function(Blueprint $table) {
			$table->dropForeign('forms_field_id_foreign');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->dropForeign('form_submissions_form_id_foreign');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->dropForeign('form_submissions_workflow_id_foreign');
		});
		Schema::table('fields', function(Blueprint $table) {
			$table->dropForeign('fields_step_id_foreign');
		});
		Schema::table('connections', function(Blueprint $table) {
			$table->dropForeign('connections_from_step_id_foreign');
		});
		Schema::table('connections', function(Blueprint $table) {
			$table->dropForeign('connections_to_step_id_foreign');
		});
		Schema::table('connections', function(Blueprint $table) {
			$table->dropForeign('connections_condition_id_foreign');
		});
	}
}