<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('role_id')->on('Role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_oper')->references('id_oper')->on('Operation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Operation', function(Blueprint $table) {
			$table->foreign('type_oper_id')->references('id_oper')->on('Operation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Operation', function(Blueprint $table) {
			$table->foreign('merchant_id')->references('id_oper')->on('Operation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Operation', function(Blueprint $table) {
			$table->foreign('user_id')->references('id_oper')->on('Operation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Operation', function(Blueprint $table) {
			$table->foreign('op_type')->references('id_oper')->on('Operation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_oper_foreign');
		});
		Schema::table('Operation', function(Blueprint $table) {
			$table->dropForeign('Operation_type_oper_id_foreign');
		});
		Schema::table('Operation', function(Blueprint $table) {
			$table->dropForeign('Operation_merchant_id_foreign');
		});
		Schema::table('Operation', function(Blueprint $table) {
			$table->dropForeign('Operation_user_id_foreign');
		});
		Schema::table('Operation', function(Blueprint $table) {
			$table->dropForeign('Operation_op_type_foreign');
		});
	}
}