<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventTable extends Migration {

	public function up()
	{
		Schema::create('Event', function(Blueprint $table) {
			$table->increments('EventID');
			$table->integer('EventTypeID')->unsigned();
			$table->string('EventTitle', 60);
			$table->text('EventDetails');
			$table->integer('EventLeadID')->unsigned();
			$table->time('EventStartTime');
			$table->date('EventStartDate');
			$table->date('EventEndDate');
			$table->time('EventEndTime');
			$table->integer('EventLocationID')->unsigned();
			$table->smallInteger('EventCap')->default('100');
			$table->datetime('ModificationData');
		});
	}

	public function down()
	{
		Schema::drop('Event');
	}
}