<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('body');
			$table->string('title');
			$table->text('route')->nullable();
			$table->tinyInteger('seen')->default('0');
			$table->timestamps();
			$table->string('related_type');
			$table->bigInteger('related_id');
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}