<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('code');
			$table->double('total_price');
			$table->integer('coupon_id')->unsigned();
			$table->double('total_after_discount')->nullable();
			$table->string('phone');
			$table->string('name');
			$table->string('email');
			$table->integer('government_id');
			$table->integer('city_id')->unsigned();
			$table->string('address');
			$table->integer('customer_id')->unsigned();
			$table->integer('payment_method_id')->unsigned();
			$table->date('receivedDate');
			$table->enum('status', array('pedning', 'completed', 'inprogress', 'canceled'));
			$table->integer('address_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}