<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('address');
			$table->integer('city_id')->unsigned();
			$table->integer('government_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->enum('status', array('billing', 'shipping', 'normal'));
			$table->string('name')->nullable();
			$table->string('phone');
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}