<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('product_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('short_description');
			$table->integer('product_id')->unsigned();
			$table->string('locale');
			$table->longText('content');
		});
	}

	public function down()
	{
		Schema::drop('product_translations');
	}
}