<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('sku')->unique();
			$table->integer('quantity');
			$table->integer('saled_quantity');
			$table->integer('available_quantity');
			$table->string('is_active');
			$table->integer('featured')->default('0');
			$table->enum('allow_reviews', array('0', '1'));
			$table->integer('low_stock')->default('0');
			$table->string('slug')->unique();
			$table->integer('restock')->default('0');
			$table->string('purchase_note')->nullable();
			$table->integer('company_id')->unsigned();
			$table->integer('created_by')->unsigned();
			$table->string('length')->nullable();
			$table->string('height')->nullable();
			$table->string('width')->nullable();
			$table->double('discount_value');
			$table->enum('discount_type', array('percent', 'value'))->nullable();
			$table->timestamp('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}