<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientTable extends Migration {

	public function up()
	{
		Schema::create('client', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->unsigned();
			$table->string('name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('phone_number', 255)->nullable();
			$table->string('land_phone', 255)->nullable();
			$table->string('position', 255)->nullable();
			$table->tinyInteger('is_active')->nullable()->default('0');
			$table->tinyInteger('is_approved')->nullable()->default('0');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('client');
	}
}