<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('location', function(Blueprint $table) {
			$table->foreign('franchise_id')->references('id')->on('admin_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('client_manager')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('staff_otp', function(Blueprint $table) {
			$table->foreign('staff_id')->references('id')->on('staff')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client_otp', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('client')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('staff_availability', function(Blueprint $table) {
			$table->foreign('staff_id')->references('id')->on('staff')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('location', function(Blueprint $table) {
			$table->dropForeign('location_franchise_id_foreign');
		});
		Schema::table('client', function(Blueprint $table) {
			$table->dropForeign('client_company_id_foreign');
		});
		Schema::table('staff_otp', function(Blueprint $table) {
			$table->dropForeign('staff_otp_staff_id_foreign');
		});
		Schema::table('client_otp', function(Blueprint $table) {
			$table->dropForeign('client_otp_client_id_foreign');
		});
		Schema::table('staff_availability', function(Blueprint $table) {
			$table->dropForeign('staff_availability_staff_id_foreign');
		});
	}
}