<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminUsersTable extends Migration {

	public function up()
	{
		Schema::create('admin_users', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('password', 255)->nullable();
			$table->string('phone_number', 255)->nullable();
			$table->tinyInteger('role')->nullable();
			$table->string('location', 255)->unique()->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('admin_users');
	}
}