<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->nullable();
			$table->integer('title_id')->nullable();
			$table->integer('category_id')->nullable();
			$table->integer('location_id')->nullable();
			$table->longText('instruction')->nullable();
			$table->string('ward_unit', 255)->nullable();
			$table->date('job_date')->nullable();
			$table->time('start_time')->nullable();
			$table->time('end_time')->nullable();
			$table->tinyInteger('job_type')->nullable();
			$table->integer('assigned_to')->nullable();
			$table->tinyInteger('assigned_type')->nullable();
			$table->integer('picked_by')->nullable();
			$table->integer('status')->nullable();
			$table->tinyInteger('is_active')->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}