<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('from_staff')->nullable();
			$table->integer('from_client')->nullable();
			$table->integer('from_admin')->nullable();
			$table->integer('to_staff')->nullable();
			$table->integer('to_client')->nullable();
			$table->integer('notification_type')->nullable();
			$table->tinyInteger('is_active')->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}