<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssesmentTable extends Migration {

	public function up()
	{
		Schema::create('assesment', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('teacher_id')->unsigned();
			$table->integer('subject_id')->unsigned();
			$table->integer('assesment_type_id')->unsigned();
			$table->integer('section_id')->unsigned();
			$table->string('academic_year', 255);
			$table->integer('semester');
			$table->boolean('locked')->default(1);
			$table->integer('max_score')->unsigned();
			$table->string('feedback', 255);
			$table->string('remark', 255);
		});
	}

	public function down()
	{
		Schema::drop('assesment');
	}
}