<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLanguageTable extends Migration {

	public function up()
	{
		Schema::create('language', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('code', 5);
			$table->string('locale', 255);
			$table->string('image', 255);
			$table->string('directory', 32);
			$table->tinyInteger('status');
			$table->smallInteger('sort_order');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('language');
	}
}