<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateManufacturerTable extends Migration {

	public function up()
	{
		Schema::create('manufacturer', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 64);
			$table->string('image', 255)->default('NULL');
			$table->smallInteger('sort_order');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('manufacturer');
	}
}