<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('role_id')->unsigned()->nullable();
			$table->bigInteger('classe_id')->unsigned()->nullable();
			$table->string('name')->nullable();
			$table->datetime('email_verified_at')->nullable();
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('email');
			$table->string('password');
			$table->integer('mobile_number')->nullable()->default('20');
			$table->string('address')->nullable();
			$table->string('school_name')->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->date('date_of_birth')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}