<?php

namespace guide;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Guide extends Model 
{

    protected $table = 'guides';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function guidquestion()
    {
        return $this->belongsTo('GuideQuestion');
    }

    public function board()
    {
        return $this->hasOne('Board');
    }

    public function classe()
    {
        return $this->hasOne('Classe');
    }

    public function subject()
    {
        return $this->hasOne('Subject');
    }

}