<?php

namespace quiz;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Quiz extends Eloquent {

	protected $table = 'quizes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function userquiz()
	{
		return $this->belongsTo('UserQuiz');
	}

	public function quizquestion()
	{
		return $this->belongsTo('QuizQuestion');
	}

	public function board()
	{
		return $this->hasOne('Board');
	}

	public function classe()
	{
		return $this->hasOne('Classe');
	}

	public function subject()
	{
		return $this->hasOne('Subject');
	}

	public function chapter()
	{
		return $this->hasOne('Chapter');
	}

	public function quizresult()
	{
		return $this->belongsTo('QuizResult');
	}

	public function quizuseranswer()
	{
		return $this->belongsTo('QuizUserAnswer');
	}

}