<?php

namespace quizresult;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class QuizResult extends Eloquent {

	protected $table = 'quiz_results';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function quiz()
	{
		return $this->hasOne('Quiz');
	}

	public function user()
	{
		return $this->hasOne('User');
	}

}