<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCreditsTable extends Migration {

	public function up()
	{
		Schema::create('credits', function(Blueprint $table) {
			$table->increments('id_credit');
			$table->integer('id_tenant')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('id_po')->unsigned();
			$table->string('credit_num', 18)->unique()->default('INV/CR/1234/000001');
			$table->datetime('credit_due_date');
			$table->string('credit_requester', 25);
			$table->enum('approved', array('yes', 'no'));
			$table->string('approval', 25);
			$table->datetime('approved_date');
			$table->datetime('paid_date');
			$table->string('paymaster', 25);
			$table->enum('status', array('open', 'closed'));
		});
	}

	public function down()
	{
		Schema::drop('credits');
	}
}