<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id_customer');
			$table->integer('id_tenant')->unsigned();
			$table->integer('id_discount');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 25)->unique();
			$table->string('customer_number', 16)->default('CID/1234/0000001');
			$table->string('customer_address', 100);
			$table->string('customer_phone', 20);
			$table->enum('disable', array('yes', 'no'));
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}