<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class LowLevelAttribute extends Model 
{

    protected $table = 'low_level_attributes';
    public $timestamps = true;
    protected $fillable = array('paper_id', 'technical_low_level_id', 'name');

    public function technical_low_level()
    {
        return $this->belongsTo('Models\TechnicalLowLevel', 'technical_low_level_id');
    }

    public function paper()
    {
        return $this->belongsTo('Models\Paper');
    }

}