<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstitutionsTable extends Migration {

	public function up()
	{
		Schema::create('institutions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('type_id')->unsigned();
			$table->date('begda')->index();
			$table->date('endda')->index();
			$table->string('nom', 150)->index();
			$table->string('description', 300)->nullable();
			$table->string('adresse', 100)->nullable();
			$table->string('telephone', 15)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('institutions');
	}
}