<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('communities', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('communities', function(Blueprint $table) {
			$table->foreign('poster_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('communities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('communities', function(Blueprint $table) {
			$table->dropForeign('communities_item_id_foreign');
		});
		Schema::table('communities', function(Blueprint $table) {
			$table->dropForeign('communities_poster_id_foreign');
		});
		Schema::table('communities', function(Blueprint $table) {
			$table->dropForeign('communities_user_id_foreign');
		});
	}
}