<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('users_subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->integer('subscription_id')->unsigned()->index();
			$table->json('subscription_details')->nullable();
			$table->date('purchase_date')->nullable();
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
			$table->enum('payment_status', array('Pending', 'Completed', 'Failed'))->nullable();
			$table->string('txn_id')->nullable();
			$table->enum('status', array('Active', 'Expired', 'Canceled'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users_subscriptions');
	}
}